<?php 
   /**
    *
    * copyright (c) 2013-2021 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "../include/includeBaseComponenti.php";
    include "../../../template/stile.php";
    include "classi/ComponenteTabella.php";
    
    if(isset($_GET["id"])) {
        $tabella = new ComponenteTabella($geecomDb, filter_input(INPUT_GET, "id",FILTER_SANITIZE_NUMBER_INT));
        $tabella->caricaDatiDalDatabase();
    }
    
    if(isset($_GET["status"])) {
        $status = filter_input(INPUT_GET,"status",FILTER_SANITIZE_NUMBER_INT);
    }
    else {
        $status = 0;
    }
?>
<!doctype html>
<html lang="en">
    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

        <?php
            include "../include/cssBaseComponenti.php";
        ?>
        <title>Geecom CMS - Creazione Tabella</title>
    </head>
    <body>
    
        <header>
            <?php 
                include "../../include/barraSuperiore.php";

                include "../../include/header.php";

                include "../../include/barraMenu.php";
            ?>
        </header>

        <main role="main" class="bg-light" id="main">
            <div class="container-fluid">
                <div class="row py-4">
                    <?php 
                        if($status==200) {
                            echo"<div class=\"col-12\">
                                    <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                        Tabella creata
                                        <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                            <span aria-hidden=\"true\">&times;</span>
                                        </button>
                                    </div>
                                </div>";
                        }
                        
                        if($status==250) {
                            echo"<div class=\"col-12\">
                                    <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                        Tabella modificata
                                        <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                            <span aria-hidden=\"true\">&times;</span>
                                        </button>
                                    </div>
                                </div>";
                        }
                    ?>
                    <div class="col-12">
                        <div class="form-row justify-content-between mb-3">
                            <div class="col-auto d-flex">
                                <nav aria-label="breadcrumb" class="align-self-center">
                                    <ol class="breadcrumb p-0 mb-1 mb-md-0 bg-transparent">
                                        <li class="breadcrumb-item"><a href="../../home.php">Home</a></li>
                                        <li class="breadcrumb-item"><a href="#" data-toggle="modal" data-target="#menu-componenti">Componenti</a></li>
                                        <li class="breadcrumb-item"><a href="index.php">Tabella</a></li>
                                        <li class="breadcrumb-item active" aria-current="page"><?php echo((isset($tabella)? $tabella->getNome() : "Nuova tabella"))?></li>
                                    </ol>
                                </nav>
                            </div>
                            <div class="col-auto text-right">
                                <a class="btn btn-outline-primary" href="index.php"><i class="fas fa-arrow-left mr-2"></i>Torna all'elenco</a>
                                <button class="btn btn-primary" onclick="document.formComponente.submit()"><i class="fas fa-check"></i> Salva</button>
                            </div>
                        </div>
                        <div class="card mb-4 box-shadow-lite">
                            <form name="formComponente" action="controller/controllerComponente.php" method="post">
                                <input type="text" class="d-none" name="operazione" value="<?php echo((isset($tabella) ? "modifica" : "crea")); ?>">
                                <input type="text" class="d-none" name="id" value="<?php echo((isset($tabella) ? $tabella->getId() : "0")); ?>">
                                
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-6 form-group">
                                            <label>Nome</label>
                                            <input type="text" class="form-control" id="nomeSlider" name="nome" aria-describedby="nome tabella" value="<?php echo((isset($tabella) ? $tabella->getNome() : "")) ?>" placeholder="Nome tabella">
                                        </div>
                                        <div class="col-md-3 form-group">
                                            <label for="inputPassword3" >Spazio occupato</label>
                                            <select class="form-control" name="spazioOccupato">
                                            <?php 
                                                foreach($arrayDimensioniColonna as $classe=>$descrizione) {
                                                    if(isset($tabella) && $tabella->getSpazioOccupato()==$classe) {
                                                        echo"<option value=\"$classe\" selected>$descrizione</option>";
                                                    }
                                                    else {
                                                        echo"<option value=\"$classe\">$descrizione</option>";
                                                    }
                                                }
                                            ?>
                                            </select>
                                            <small class="text-muted">Scegli lo spazio che deve occupare la tabella nella sezione</small>
                                        </div>
                                        
                                        <div class="w-100"></div>
                                        
                                        <div class="col-md-6 form-group">
                                            <label class="d-block">Intestazione</label>
                                            <input type="text" class="form-control" name="intestazione" aria-describedby="intestazione" value="<?php echo((isset($tabella) ? $tabella->getIntestazione() : "")) ?>" placeholder="intestazione">
                                            <small class="text-muted">Inserisci i campi separati da una virgola, lascia in bianco se non vuoi l'intestazione</small>
                                        </div>
                                        
                                        <div class="col-md-3 form-group">
                                            <label class="d-block">Sfondo intestazione</label>
                                            <div class="input-group colorpicker-component selettore-colore">
                                                <input type="text" class="form-control" name="sfondoIntestazione" value="<?php echo((isset($tabella) ? $tabella->getSfondoIntestazione() : "")) ?>" placeholder="Sfondo intestazione" />
                                                <span class="input-group-append"><span class="input-group-addon input-group-text"><i></i></span></span>
                                            </div>
                                            <small class="text-muted">Scegli il colore di sfondo dell'intestazione</small>
                                        </div>
                                        
                                        <div class="col-md-3 form-group">
                                            <label class="d-block">Colore testi intestazione</label>
                                            <div class="input-group colorpicker-component selettore-colore">
                                                <input type="text" class="form-control" name="coloreTestiIntestazione" value="<?php echo((isset($tabella) ? $tabella->getColoreTestiIntestazione() : "")) ?>" placeholder="Colore testi  intestazione" />
                                                <span class="input-group-append"><span class="input-group-addon input-group-text"><i></i></span></span>
                                            </div>
                                            <small class="text-muted">Scegli il colore di sfondo dell'intestazione</small>
                                        </div>
                                        
                                        <div class="w-100"></div>
                                        
                                        <div class="col-md-6 form-group">
                                            <label class="d-block">Note</label>
                                            <input type="text" class="form-control" id="nomeSlider" name="note" aria-describedby="note" value="<?php echo((isset($tabella) ? $tabella->getNote() : "")) ?>" placeholder="note">
                                            <small class="text-muted">Inserisci qui eventuali note da far comparire sotto la tabella</small>
                                        </div>
                                        
                                        <div class="col-md-2 form-group">
                                            <label class="d-block">Ordinabile</label>
                                            <input type="checkbox" name="ordinabile" class="js-switch" <?php echo((isset($tabella) && $tabella->getOrdinabile()=="si") ? "checked" : "1") ?> value="si">
                                        </div>
                                    </div>
                                </div>
                            </form>
                            <div class="card-footer">
                                <button type="button" class="btn btn-primary float-right" onclick="document.formComponente.submit()"><i class="fas fa-check"></i> Salva</button>
                            </div>
                        </div>
                        <div class="card mb-4 box-shadow-lite">
                            <?php 
                                if(isset($tabella)) {
                            ?>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-lg-4 col-xl-3 align-self-start sticky-top">
                                        <form>
                                            <div class="mb-4 add-box">
                                                <h5 class="mb-3"> Aggiungi riga </h5>
                                                <div class="options-box">
                                                    <div class="form-group">
                                                        <label>Elementi</label>
                                                        <input type="text" class="form-control" id="elementiElemento" placeholder="Elementi">
                                                        <small class="text-muted">Inserisci gli elementi della riga separati da una virgola, ad esempio <b>a,b,c</b></small>
                                                    </div>

                                                    <div class="form-group">
                                                        <label>Colore sfondo</label>
                                                        <div class="input-group colorpicker-component selettore-colore">
                                                            <input type="text" class="form-control" id="coloreSfondoElemento" placeholder="Colore sfondo" />
                                                            <span class="input-group-append"><span class="input-group-addon input-group-text"><i></i></span></span>
                                                        </div>
                                                    </div>
                                                    
                                                    <div class="form-group">
                                                        <label>Colore testi</label>
                                                        <div class="input-group colorpicker-component selettore-colore">
                                                            <input type="text" class="form-control" id="coloreTestiElemento" placeholder="Colore testi" />
                                                            <span class="input-group-append"><span class="input-group-addon input-group-text"><i></i></span></span>
                                                        </div>
                                                    </div>
                                                    
                                                    <button type="button" class="btn btn-primary float-right" value="Crea" onclick="creaElemento()"><i class="fas fa-plus mr-2"></i>Crea</button>
                                                </div>
                                            </div>
                                        </form>
                                    </div>

                                    <div id="divElencoElementi" class="col-lg-8 col-xl-9 mb-4 gerarchia-menu">
                                        <?php 
                                            $tabella->stampaElementi();
                                        ?>
                                    </div>
                                </div>
                            </div>
                            <?php
                                }
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </main>

        <?php
            include "../../include/footer.php";

            include "../include/modal/cambiaPassword.php";
            
            include "../include/modal/eliminaElemento.php";

            include "../../include/modal/modalMenuComponenti.php";

            include "../../include/modal/operazioneCompletata.php";

            include "../include/jsBaseComponenti.php";
        ?>

        <script>
            function eliminaElemento(id,nomeElemento,tipoElemento) {
                $('#elementoDaEliminare').val(id);
                $('#nomeElementoDaEliminare').text(nomeElemento);
                $('#modalEliminaElemento').modal('show');
            }
            
            function eseguiEliminazioneElemento() {
                var id = $('#elementoDaEliminare').val();
                $.ajax({
                    type:"POST",
                    url:"controller/controllerComponente.php",
                    data:{
                        operazione:"eliminaElemento",
                        id:<?php echo $tabella->getId() ?>,
                        idElemento:id
                    },
                    success:function(esito) {
                        if(esito=="ok") {
                            document.getElementById("elementoComponente"+id).className = "d-none";
                            $('#modalEliminaElemento').modal('hide');
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function spostaElementoInput(id) {
                var posizione = $('#nuovaPosizioneElemento'+id).val();
                spostaElemento(id,posizione);
            }
            
            function spostaElemento(id,posizione) {
                $.ajax({
                    type:"POST",
                    url:"controller/controllerComponente.php",
                    data:{
                        operazione:"spostaElemento",
                        id:<?php echo $tabella->getId() ?>,
                        idElemento:id,
                        posizione:posizione
                    },
                    success:function(esito) {
                        if(esito=="ok") {
                            aggiornaDivElementi();
                        }
                        else {
                            alert(esito);
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function creaElemento() {
                var elementi     = $('#elementiElemento').val();
                var coloreSfondo = $('#coloreSfondoElemento').val();
                var coloreTesti  = $('#coloreTestiElemento').val();
                
                $.ajax({
                    type:"POST",
                    url:"controller/controllerComponente.php",
                    data:{
                        operazione:"creaElemento",
                        id:<?php echo $tabella->getId() ?>,
                        elementi:elementi,
                        coloreSfondo:coloreSfondo,
                        coloreTesti:coloreTesti
                    },
                    success:function(esito) {
                        if(esito=="ok") {
                            aggiornaDivElementi();
                        }
                        else {
                            alert(esito);
                            alert("Si è verificato un errore, contatta l'amministratore del sito")
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function aggiornaDivElementi() {
                $.ajax({
                    type:"POST",
                    url:"controller/controllerComponente.php",
                    data:{
                        operazione:"stampaElementi",
                        id:<?php echo $tabella->getId() ?>
                    },
                    success:function(result) {
                        document.getElementById("divElencoElementi").innerHTML = result;
                        $('#modifica-voce-menu').modal('hide');
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
        </script>
    </body>
</html>
